/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.scrollabletooltips.mixinextras.utils;

import club.sk1er.mods.scrollabletooltips.mixinextras.utils.ASMUtils;
import club.sk1er.mods.scrollabletooltips.mixinextras.utils.CompatibilityHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.modify.LocalVariableDiscriminator;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Bytecode;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.asm.util.SignaturePrinter;

public class InjectorUtils {
    public static boolean isVirtualRedirect(InjectionNodes.InjectionNode node2) {
        return node2.isReplaced() && node2.hasDecoration("redirector") && node2.getCurrentTarget().getOpcode() != 184;
    }

    public static boolean isDynamicInstanceofRedirect(InjectionNodes.InjectionNode node2) {
        AbstractInsnNode originalTarget = node2.getOriginalTarget();
        AbstractInsnNode currentTarget = node2.getCurrentTarget();
        return originalTarget.getOpcode() == 193 && currentTarget instanceof MethodInsnNode && Type.getReturnType((String)((MethodInsnNode)currentTarget).desc).equals((Object)Type.getType(Class.class));
    }

    public static void checkForDupedNews(Map<Target, List<InjectionNodes.InjectionNode>> targets) {
        for (Map.Entry<Target, List<InjectionNodes.InjectionNode>> entry : targets.entrySet()) {
            for (InjectionNodes.InjectionNode node2 : entry.getValue()) {
                AbstractInsnNode currentTarget = node2.getCurrentTarget();
                if (currentTarget.getOpcode() != 187 || currentTarget.getNext().getOpcode() != 89) continue;
                node2.decorate("mixinextras_newIsDuped", (Object)true);
            }
        }
    }

    public static boolean isDupedNew(InjectionNodes.InjectionNode node2) {
        AbstractInsnNode currentTarget = node2.getCurrentTarget();
        return currentTarget != null && currentTarget.getOpcode() == 187 && node2.hasDecoration("mixinextras_newIsDuped");
    }

    public static boolean isDupedFactoryRedirect(InjectionNodes.InjectionNode node2) {
        AbstractInsnNode originalTarget = node2.getOriginalTarget();
        return node2.isReplaced() && originalTarget.getOpcode() == 187 && !node2.hasDecoration("mixinextras_wrappedOperation") && node2.hasDecoration("mixinextras_newIsDuped");
    }

    public static void checkForImmediatePops(Map<Target, List<InjectionNodes.InjectionNode>> targets) {
        for (List<InjectionNodes.InjectionNode> nodeList : targets.values()) {
            for (InjectionNodes.InjectionNode node2 : nodeList) {
                Type returnType;
                AbstractInsnNode currentTarget = node2.getCurrentTarget();
                if (!(currentTarget instanceof MethodInsnNode) || !InjectorUtils.isTypePoppedByInstruction(returnType = Type.getReturnType((String)((MethodInsnNode)currentTarget).desc), currentTarget.getNext())) continue;
                node2.decorate("mixinextras_operationIsImmediatelyPopped", (Object)true);
            }
        }
    }

    private static boolean isTypePoppedByInstruction(Type type, AbstractInsnNode insn) {
        switch (type.getSize()) {
            case 2: {
                return insn.getOpcode() == 88;
            }
            case 1: {
                return insn.getOpcode() == 87;
            }
        }
        return false;
    }

    public static LocalVariableDiscriminator.Context getOrCreateLocalContext(Target target, InjectionNodes.InjectionNode node2, InjectionInfo info, Type targetType, boolean isArgsOnly) {
        String decorationKey = InjectorUtils.getLocalContextKey(targetType, isArgsOnly);
        if (node2.hasDecoration(decorationKey)) {
            return (LocalVariableDiscriminator.Context)node2.getDecoration(decorationKey);
        }
        LocalVariableDiscriminator.Context context = CompatibilityHelper.makeLvtContext(info, targetType, isArgsOnly, target, node2.getCurrentTarget());
        node2.decorate(decorationKey, (Object)context);
        return context;
    }

    private static String getLocalContextKey(Type targetType, boolean isArgsOnly) {
        return String.format("mixinextras_persistent_localContext(%s,%s)", targetType, isArgsOnly ? "argsOnly" : "fullFrame");
    }

    public static void printLocals(Target target, AbstractInsnNode node2, LocalVariableDiscriminator.Context context, LocalVariableDiscriminator discriminator, Type targetType, boolean isArgsOnly) {
        int baseArgIndex = target.isStatic ? 0 : 1;
        new PrettyPrinter().kvWidth(20).kv("Target Class", (Object)target.classNode.name.replace('/', '.')).kv("Target Method", (Object)target.method.name).kv("Capture Type", (Object)SignaturePrinter.getTypeName((Type)targetType, (boolean)false)).kv("Instruction", "[%d] %s %s", new Object[]{target.insns.indexOf(node2), node2.getClass().getSimpleName(), Bytecode.getOpcodeName((int)node2.getOpcode())}).hr().kv("Match mode", (Object)(InjectorUtils.isImplicit(discriminator, baseArgIndex) ? "IMPLICIT (match single)" : "EXPLICIT (match by criteria)")).kv("Match ordinal", discriminator.getOrdinal() < 0 ? "any" : Integer.valueOf(discriminator.getOrdinal())).kv("Match index", discriminator.getIndex() < baseArgIndex ? "any" : Integer.valueOf(discriminator.getIndex())).kv("Match name(s)", discriminator.hasNames() ? discriminator.getNames() : "any").kv("Args only", (Object)isArgsOnly).hr().add((PrettyPrinter.IPrettyPrintable)context).print(System.err);
    }

    private static boolean isImplicit(LocalVariableDiscriminator discriminator, int baseArgIndex) {
        return discriminator.getOrdinal() < 0 && discriminator.getIndex() < baseArgIndex && discriminator.getNames().isEmpty();
    }

    public static void decorateInjectorSpecific(InjectionNodes.InjectionNode node2, InjectionInfo info, String key, Object value) {
        if (!node2.hasDecoration(key)) {
            node2.decorate(key, new HashMap());
        }
        Map inner = (Map)node2.getDecoration(key);
        inner.put(info, value);
    }

    public static <T> T getInjectorSpecificDecoration(InjectionNodes.InjectionNode node2, InjectionInfo info, String key) {
        Map map2 = (Map)node2.getDecoration(key);
        if (map2 == null) {
            return null;
        }
        return (T)map2.get(info);
    }

    public static boolean hasInjectorSpecificDecoration(InjectionNodes.InjectionNode node2, InjectionInfo info, String key) {
        Map map2 = (Map)node2.getDecoration(key);
        if (map2 == null) {
            return false;
        }
        return map2.containsKey(info);
    }

    public static void coerceReturnType(Injector.InjectorData data, InsnList insns, Type expectedReturnType) {
        if (data.coerceReturnType && expectedReturnType.getSort() >= 9) {
            insns.add((AbstractInsnNode)new TypeInsnNode(192, expectedReturnType.getInternalName()));
        }
    }

    public static AbstractInsnNode findCoerce(InjectionNodes.InjectionNode target, Type expectedType) {
        if (!target.isReplaced() || InjectorUtils.isDynamicInstanceofRedirect(target)) {
            return null;
        }
        AbstractInsnNode currentTarget = target.getCurrentTarget();
        if (!(currentTarget instanceof MethodInsnNode)) {
            return null;
        }
        MethodInsnNode handlerCall = (MethodInsnNode)currentTarget;
        if (ASMUtils.isPrimitive(expectedType) || Type.getReturnType((String)handlerCall.desc).equals((Object)expectedType)) {
            return null;
        }
        if (handlerCall.getNext().getOpcode() == 192) {
            TypeInsnNode cast = (TypeInsnNode)handlerCall.getNext();
            if (cast.desc.equals(expectedType.getInternalName())) {
                return cast;
            }
        }
        throw new AssertionError((Object)String.format("Could not find @Coerce CHECKCAST instruction! Expected '%s' but got '%s'! Please inform LlamaLad7!", "[CHECKCAST] " + expectedType.getInternalName(), Bytecode.describeNode((AbstractInsnNode)handlerCall.getNext())));
    }
}

